<?php
namespace model;

class Points extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'user_id'	=>	'INT UNSIGNED',
				
				'points'	=>	'INT'
			))
		);
	}
	
	// Validation
	public function columns($preset)
	{
		return array
		(
			'user_id'	=>	array('text', array('c_user_exists'=>array($this, 'user_exists'))),
			
			'points'	=>	array('text', array('non_negative_integer'=>true))
		);
	}
	
	public function user_exists($id)
	{
		return \model\User::num_rows('WHERE id=?', $id, false);
	}
}